package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.CustomResource
import besom.ResourceDecoder
import besom.CustomResourceOptions
import besom.util.NonEmptyString


final case class TransitGatewayVpcAttachment private(
  urn: Output[besom.types.URN],
  id: Output[besom.types.ResourceId],
  peerCloudAccount: Output[String],
  peerRegion: Output[Option[String]],
  peerVpc: Output[String],
  peeringConnectionId: Output[String],
  state: Output[String],
  stateInfo: Output[scala.Predef.Map[String, besom.types.PulumiAny]],
  userPeerNetworkCidrs: Output[scala.collection.immutable.List[String]],
  vpcId: Output[String]
) extends CustomResource derives ResourceDecoder

object TransitGatewayVpcAttachment:
  given outputOps: {} with
    extension(output: Output[TransitGatewayVpcAttachment])
      def urn: Output[besom.types.URN] = output.flatMap(_.urn)
      def id: Output[besom.types.ResourceId] = output.flatMap(_.id)
      def peerCloudAccount: Output[String] = output.flatMap(_.peerCloudAccount)
      def peerRegion: Output[Option[String]] = output.flatMap(_.peerRegion)
      def peerVpc: Output[String] = output.flatMap(_.peerVpc)
      def peeringConnectionId: Output[String] = output.flatMap(_.peeringConnectionId)
      def state: Output[String] = output.flatMap(_.state)
      def stateInfo: Output[scala.Predef.Map[String, besom.types.PulumiAny]] = output.flatMap(_.stateInfo)
      def userPeerNetworkCidrs: Output[scala.collection.immutable.List[String]] = output.flatMap(_.userPeerNetworkCidrs)
      def vpcId: Output[String] = output.flatMap(_.vpcId)

def transitGatewayVpcAttachment(using ctx: Context)(
  name: NonEmptyString,
  args: TransitGatewayVpcAttachmentArgs,
  opts: CustomResourceOptions = CustomResourceOptions()
): Output[TransitGatewayVpcAttachment] = 
  ctx.registerResource[TransitGatewayVpcAttachment, TransitGatewayVpcAttachmentArgs]("aiven:index/transitGatewayVpcAttachment:TransitGatewayVpcAttachment", name, args, opts)

