package besom.api.aiven

import besom.types.Output
import besom.types.Context
import besom.Input
import besom.Encoder
import besom.ArgsEncoder

final case class TransitGatewayVpcAttachmentArgs private(
  peerCloudAccount: Output[String],
  peerRegion: Output[Option[String]],
  peerVpc: Output[String],
  userPeerNetworkCidrs: Output[scala.collection.immutable.List[String]],
  vpcId: Output[String]
) derives ArgsEncoder

object TransitGatewayVpcAttachmentArgs:
  def apply(
    peerCloudAccount: Input[String],
    peerRegion: Input.Optional[String] = None,
    peerVpc: Input[String],
    userPeerNetworkCidrs: Input[List[Input[String]]],
    vpcId: Input[String]
  )(using Context): TransitGatewayVpcAttachmentArgs =
    new TransitGatewayVpcAttachmentArgs(
      peerCloudAccount = peerCloudAccount.asOutput(isSecret = false),
      peerRegion = peerRegion.asOptionOutput(isSecret = false),
      peerVpc = peerVpc.asOutput(isSecret = false),
      userPeerNetworkCidrs = userPeerNetworkCidrs.asOutput(isSecret = false),
      vpcId = vpcId.asOutput(isSecret = false)
    )
