package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class AccountAuthenticationSamlFieldMappingArgs private(
  email: Output[Option[String]],
  firstName: Output[Option[String]],
  identity: Output[Option[String]],
  lastName: Output[Option[String]],
  realName: Output[Option[String]]
) derives Encoder, ArgsEncoder

object AccountAuthenticationSamlFieldMappingArgs:
  def apply(
    email: Input.Optional[String] = None,
    firstName: Input.Optional[String] = None,
    identity: Input.Optional[String] = None,
    lastName: Input.Optional[String] = None,
    realName: Input.Optional[String] = None
  )(using Context): AccountAuthenticationSamlFieldMappingArgs =
    new AccountAuthenticationSamlFieldMappingArgs(
      email = email.asOptionOutput(isSecret = false),
      firstName = firstName.asOptionOutput(isSecret = false),
      identity = identity.asOptionOutput(isSecret = false),
      lastName = lastName.asOptionOutput(isSecret = false),
      realName = realName.asOptionOutput(isSecret = false)
    )
