package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class CassandraCassandraUserConfigIpFilterObjectArgs private(
  description: Output[Option[String]],
  network: Output[String]
) derives Encoder, ArgsEncoder

object CassandraCassandraUserConfigIpFilterObjectArgs:
  def apply(
    description: Input.Optional[String] = None,
    network: Input[String]
  )(using Context): CassandraCassandraUserConfigIpFilterObjectArgs =
    new CassandraCassandraUserConfigIpFilterObjectArgs(
      description = description.asOptionOutput(isSecret = false),
      network = network.asOutput(isSecret = false)
    )
