package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class CassandraComponentArgs private(
  component: Output[Option[String]],
  host: Output[Option[String]],
  kafkaAuthenticationMethod: Output[Option[String]],
  port: Output[Option[Int]],
  route: Output[Option[String]],
  ssl: Output[Option[Boolean]],
  usage: Output[Option[String]]
) derives Encoder, ArgsEncoder

object CassandraComponentArgs:
  def apply(
    component: Input.Optional[String] = None,
    host: Input.Optional[String] = None,
    kafkaAuthenticationMethod: Input.Optional[String] = None,
    port: Input.Optional[Int] = None,
    route: Input.Optional[String] = None,
    ssl: Input.Optional[Boolean] = None,
    usage: Input.Optional[String] = None
  )(using Context): CassandraComponentArgs =
    new CassandraComponentArgs(
      component = component.asOptionOutput(isSecret = false),
      host = host.asOptionOutput(isSecret = false),
      kafkaAuthenticationMethod = kafkaAuthenticationMethod.asOptionOutput(isSecret = false),
      port = port.asOptionOutput(isSecret = false),
      route = route.asOptionOutput(isSecret = false),
      ssl = ssl.asOptionOutput(isSecret = false),
      usage = usage.asOptionOutput(isSecret = false)
    )
