package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class CassandraServiceIntegrationArgs private(
  integrationType: Output[String],
  sourceServiceName: Output[String]
) derives Encoder, ArgsEncoder

object CassandraServiceIntegrationArgs:
  def apply(
    integrationType: Input[String],
    sourceServiceName: Input[String]
  )(using Context): CassandraServiceIntegrationArgs =
    new CassandraServiceIntegrationArgs(
      integrationType = integrationType.asOutput(isSecret = false),
      sourceServiceName = sourceServiceName.asOutput(isSecret = false)
    )
