package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ClickhouseGrantPrivilegeGrantArgs private(
  column: Output[Option[String]],
  database: Output[String],
  privilege: Output[Option[String]],
  table: Output[Option[String]],
  withGrant: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object ClickhouseGrantPrivilegeGrantArgs:
  def apply(
    column: Input.Optional[String] = None,
    database: Input[String],
    privilege: Input.Optional[String] = None,
    table: Input.Optional[String] = None,
    withGrant: Input.Optional[Boolean] = None
  )(using Context): ClickhouseGrantPrivilegeGrantArgs =
    new ClickhouseGrantPrivilegeGrantArgs(
      column = column.asOptionOutput(isSecret = false),
      database = database.asOutput(isSecret = false),
      privilege = privilege.asOptionOutput(isSecret = false),
      table = table.asOptionOutput(isSecret = false),
      withGrant = withGrant.asOptionOutput(isSecret = false)
    )
