package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class ClickhouseTagArgs private(
  key: Output[String],
  value: Output[String]
) derives Encoder, ArgsEncoder

object ClickhouseTagArgs:
  def apply(
    key: Input[String],
    value: Input[String]
  )(using Context): ClickhouseTagArgs =
    new ClickhouseTagArgs(
      key = key.asOutput(isSecret = false),
      value = value.asOutput(isSecret = false)
    )
