package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class FlinkApplicationVersionSinkArgs private(
  createTable: Output[String],
  integrationId: Output[Option[String]]
) derives Encoder, ArgsEncoder

object FlinkApplicationVersionSinkArgs:
  def apply(
    createTable: Input[String],
    integrationId: Input.Optional[String] = None
  )(using Context): FlinkApplicationVersionSinkArgs =
    new FlinkApplicationVersionSinkArgs(
      createTable = createTable.asOutput(isSecret = false),
      integrationId = integrationId.asOptionOutput(isSecret = false)
    )
