package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class FlinkApplicationVersionSourceArgs private(
  createTable: Output[String],
  integrationId: Output[Option[String]]
) derives Encoder, ArgsEncoder

object FlinkApplicationVersionSourceArgs:
  def apply(
    createTable: Input[String],
    integrationId: Input.Optional[String] = None
  )(using Context): FlinkApplicationVersionSourceArgs =
    new FlinkApplicationVersionSourceArgs(
      createTable = createTable.asOutput(isSecret = false),
      integrationId = integrationId.asOptionOutput(isSecret = false)
    )
