package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCassandraCassandraUserConfigArgs private(
  additionalBackupRegions: Output[Option[String]],
  backupHour: Output[Option[Int]],
  backupMinute: Output[Option[Int]],
  cassandra: Output[Option[besom.api.aiven.inputs.GetCassandraCassandraUserConfigCassandraArgs]],
  cassandraVersion: Output[Option[String]],
  ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.GetCassandraCassandraUserConfigIpFilterObjectArgs]]],
  ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]],
  ipFilters: Output[Option[scala.collection.immutable.List[String]]],
  migrateSstableloader: Output[Option[Boolean]],
  privateAccess: Output[Option[besom.api.aiven.inputs.GetCassandraCassandraUserConfigPrivateAccessArgs]],
  projectToForkFrom: Output[Option[String]],
  publicAccess: Output[Option[besom.api.aiven.inputs.GetCassandraCassandraUserConfigPublicAccessArgs]],
  serviceToForkFrom: Output[Option[String]],
  serviceToJoinWith: Output[Option[String]],
  staticIps: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetCassandraCassandraUserConfigArgs:
  def apply(
    additionalBackupRegions: Input.Optional[String] = None,
    backupHour: Input.Optional[Int] = None,
    backupMinute: Input.Optional[Int] = None,
    cassandra: Input.Optional[besom.api.aiven.inputs.GetCassandraCassandraUserConfigCassandraArgs] = None,
    cassandraVersion: Input.Optional[String] = None,
    ipFilterObjects: Input.Optional[List[Input[besom.api.aiven.inputs.GetCassandraCassandraUserConfigIpFilterObjectArgs]]] = None,
    ipFilterStrings: Input.Optional[List[Input[String]]] = None,
    ipFilters: Input.Optional[List[Input[String]]] = None,
    migrateSstableloader: Input.Optional[Boolean] = None,
    privateAccess: Input.Optional[besom.api.aiven.inputs.GetCassandraCassandraUserConfigPrivateAccessArgs] = None,
    projectToForkFrom: Input.Optional[String] = None,
    publicAccess: Input.Optional[besom.api.aiven.inputs.GetCassandraCassandraUserConfigPublicAccessArgs] = None,
    serviceToForkFrom: Input.Optional[String] = None,
    serviceToJoinWith: Input.Optional[String] = None,
    staticIps: Input.Optional[Boolean] = None
  )(using Context): GetCassandraCassandraUserConfigArgs =
    new GetCassandraCassandraUserConfigArgs(
      additionalBackupRegions = additionalBackupRegions.asOptionOutput(isSecret = false),
      backupHour = backupHour.asOptionOutput(isSecret = false),
      backupMinute = backupMinute.asOptionOutput(isSecret = false),
      cassandra = cassandra.asOptionOutput(isSecret = false),
      cassandraVersion = cassandraVersion.asOptionOutput(isSecret = false),
      ipFilterObjects = ipFilterObjects.asOptionOutput(isSecret = false),
      ipFilterStrings = ipFilterStrings.asOptionOutput(isSecret = false),
      ipFilters = ipFilters.asOptionOutput(isSecret = false),
      migrateSstableloader = migrateSstableloader.asOptionOutput(isSecret = false),
      privateAccess = privateAccess.asOptionOutput(isSecret = false),
      projectToForkFrom = projectToForkFrom.asOptionOutput(isSecret = false),
      publicAccess = publicAccess.asOptionOutput(isSecret = false),
      serviceToForkFrom = serviceToForkFrom.asOptionOutput(isSecret = false),
      serviceToJoinWith = serviceToJoinWith.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false)
    )
