package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCassandraCassandraUserConfigCassandraArgs private(
  batchSizeFailThresholdInKb: Output[Option[Int]],
  batchSizeWarnThresholdInKb: Output[Option[Int]],
  datacenter: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetCassandraCassandraUserConfigCassandraArgs:
  def apply(
    batchSizeFailThresholdInKb: Input.Optional[Int] = None,
    batchSizeWarnThresholdInKb: Input.Optional[Int] = None,
    datacenter: Input.Optional[String] = None
  )(using Context): GetCassandraCassandraUserConfigCassandraArgs =
    new GetCassandraCassandraUserConfigCassandraArgs(
      batchSizeFailThresholdInKb = batchSizeFailThresholdInKb.asOptionOutput(isSecret = false),
      batchSizeWarnThresholdInKb = batchSizeWarnThresholdInKb.asOptionOutput(isSecret = false),
      datacenter = datacenter.asOptionOutput(isSecret = false)
    )
