package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCassandraServiceIntegrationArgs private(
  integrationType: Output[String],
  sourceServiceName: Output[String]
) derives Encoder, ArgsEncoder

object GetCassandraServiceIntegrationArgs:
  def apply(
    integrationType: Input[String],
    sourceServiceName: Input[String]
  )(using Context): GetCassandraServiceIntegrationArgs =
    new GetCassandraServiceIntegrationArgs(
      integrationType = integrationType.asOutput(isSecret = false),
      sourceServiceName = sourceServiceName.asOutput(isSecret = false)
    )
