package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCassandraTagArgs private(
  key: Output[String],
  value: Output[String]
) derives Encoder, ArgsEncoder

object GetCassandraTagArgs:
  def apply(
    key: Input[String],
    value: Input[String]
  )(using Context): GetCassandraTagArgs =
    new GetCassandraTagArgs(
      key = key.asOutput(isSecret = false),
      value = value.asOutput(isSecret = false)
    )
