package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetClickhouseClickhouseUserConfigPublicAccessArgs private(
  clickhouse: Output[Option[Boolean]],
  clickhouseHttps: Output[Option[Boolean]],
  prometheus: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetClickhouseClickhouseUserConfigPublicAccessArgs:
  def apply(
    clickhouse: Input.Optional[Boolean] = None,
    clickhouseHttps: Input.Optional[Boolean] = None,
    prometheus: Input.Optional[Boolean] = None
  )(using Context): GetClickhouseClickhouseUserConfigPublicAccessArgs =
    new GetClickhouseClickhouseUserConfigPublicAccessArgs(
      clickhouse = clickhouse.asOptionOutput(isSecret = false),
      clickhouseHttps = clickhouseHttps.asOptionOutput(isSecret = false),
      prometheus = prometheus.asOptionOutput(isSecret = false)
    )
