package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetClickhouseTagArgs private(
  key: Output[String],
  value: Output[String]
) derives Encoder, ArgsEncoder

object GetClickhouseTagArgs:
  def apply(
    key: Input[String],
    value: Input[String]
  )(using Context): GetClickhouseTagArgs =
    new GetClickhouseTagArgs(
      key = key.asOutput(isSecret = false),
      value = value.asOutput(isSecret = false)
    )
