package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetFlinkComponentArgs private(
  component: Output[String],
  host: Output[String],
  kafkaAuthenticationMethod: Output[String],
  port: Output[Int],
  route: Output[String],
  ssl: Output[Boolean],
  usage: Output[String]
) derives Encoder, ArgsEncoder

object GetFlinkComponentArgs:
  def apply(
    component: Input[String],
    host: Input[String],
    kafkaAuthenticationMethod: Input[String],
    port: Input[Int],
    route: Input[String],
    ssl: Input[Boolean],
    usage: Input[String]
  )(using Context): GetFlinkComponentArgs =
    new GetFlinkComponentArgs(
      component = component.asOutput(isSecret = false),
      host = host.asOutput(isSecret = false),
      kafkaAuthenticationMethod = kafkaAuthenticationMethod.asOutput(isSecret = false),
      port = port.asOutput(isSecret = false),
      route = route.asOutput(isSecret = false),
      ssl = ssl.asOutput(isSecret = false),
      usage = usage.asOutput(isSecret = false)
    )
