package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetFlinkFlinkUserConfigArgs private(
  flinkVersion: Output[Option[String]],
  ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.GetFlinkFlinkUserConfigIpFilterObjectArgs]]],
  ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]],
  ipFilters: Output[Option[scala.collection.immutable.List[String]]],
  numberOfTaskSlots: Output[Option[Int]],
  privatelinkAccess: Output[Option[besom.api.aiven.inputs.GetFlinkFlinkUserConfigPrivatelinkAccessArgs]]
) derives Encoder, ArgsEncoder

object GetFlinkFlinkUserConfigArgs:
  def apply(
    flinkVersion: Input.Optional[String] = None,
    ipFilterObjects: Input.Optional[List[Input[besom.api.aiven.inputs.GetFlinkFlinkUserConfigIpFilterObjectArgs]]] = None,
    ipFilterStrings: Input.Optional[List[Input[String]]] = None,
    ipFilters: Input.Optional[List[Input[String]]] = None,
    numberOfTaskSlots: Input.Optional[Int] = None,
    privatelinkAccess: Input.Optional[besom.api.aiven.inputs.GetFlinkFlinkUserConfigPrivatelinkAccessArgs] = None
  )(using Context): GetFlinkFlinkUserConfigArgs =
    new GetFlinkFlinkUserConfigArgs(
      flinkVersion = flinkVersion.asOptionOutput(isSecret = false),
      ipFilterObjects = ipFilterObjects.asOptionOutput(isSecret = false),
      ipFilterStrings = ipFilterStrings.asOptionOutput(isSecret = false),
      ipFilters = ipFilters.asOptionOutput(isSecret = false),
      numberOfTaskSlots = numberOfTaskSlots.asOptionOutput(isSecret = false),
      privatelinkAccess = privatelinkAccess.asOptionOutput(isSecret = false)
    )
