package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetGrafanaGrafanaUserConfigAuthAzureadArgs private(
  allowSignUp: Output[Option[Boolean]],
  allowedDomains: Output[Option[scala.collection.immutable.List[String]]],
  allowedGroups: Output[Option[scala.collection.immutable.List[String]]],
  authUrl: Output[String],
  clientId: Output[String],
  clientSecret: Output[String],
  tokenUrl: Output[String]
) derives Encoder, ArgsEncoder

object GetGrafanaGrafanaUserConfigAuthAzureadArgs:
  def apply(
    allowSignUp: Input.Optional[Boolean] = None,
    allowedDomains: Input.Optional[List[Input[String]]] = None,
    allowedGroups: Input.Optional[List[Input[String]]] = None,
    authUrl: Input[String],
    clientId: Input[String],
    clientSecret: Input[String],
    tokenUrl: Input[String]
  )(using Context): GetGrafanaGrafanaUserConfigAuthAzureadArgs =
    new GetGrafanaGrafanaUserConfigAuthAzureadArgs(
      allowSignUp = allowSignUp.asOptionOutput(isSecret = false),
      allowedDomains = allowedDomains.asOptionOutput(isSecret = false),
      allowedGroups = allowedGroups.asOptionOutput(isSecret = false),
      authUrl = authUrl.asOutput(isSecret = false),
      clientId = clientId.asOutput(isSecret = false),
      clientSecret = clientSecret.asOutput(isSecret = false),
      tokenUrl = tokenUrl.asOutput(isSecret = false)
    )
