package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetGrafanaGrafanaUserConfigAuthGithubArgs private(
  allowSignUp: Output[Option[Boolean]],
  allowedOrganizations: Output[Option[scala.collection.immutable.List[String]]],
  clientId: Output[String],
  clientSecret: Output[String],
  teamIds: Output[Option[scala.collection.immutable.List[Int]]]
) derives Encoder, ArgsEncoder

object GetGrafanaGrafanaUserConfigAuthGithubArgs:
  def apply(
    allowSignUp: Input.Optional[Boolean] = None,
    allowedOrganizations: Input.Optional[List[Input[String]]] = None,
    clientId: Input[String],
    clientSecret: Input[String],
    teamIds: Input.Optional[List[Input[Int]]] = None
  )(using Context): GetGrafanaGrafanaUserConfigAuthGithubArgs =
    new GetGrafanaGrafanaUserConfigAuthGithubArgs(
      allowSignUp = allowSignUp.asOptionOutput(isSecret = false),
      allowedOrganizations = allowedOrganizations.asOptionOutput(isSecret = false),
      clientId = clientId.asOutput(isSecret = false),
      clientSecret = clientSecret.asOutput(isSecret = false),
      teamIds = teamIds.asOptionOutput(isSecret = false)
    )
