package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetGrafanaGrafanaUserConfigAuthGitlabArgs private(
  allowSignUp: Output[Option[Boolean]],
  allowedGroups: Output[Option[scala.collection.immutable.List[String]]],
  apiUrl: Output[Option[String]],
  authUrl: Output[Option[String]],
  clientId: Output[String],
  clientSecret: Output[String],
  tokenUrl: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetGrafanaGrafanaUserConfigAuthGitlabArgs:
  def apply(
    allowSignUp: Input.Optional[Boolean] = None,
    allowedGroups: Input.Optional[List[Input[String]]] = None,
    apiUrl: Input.Optional[String] = None,
    authUrl: Input.Optional[String] = None,
    clientId: Input[String],
    clientSecret: Input[String],
    tokenUrl: Input.Optional[String] = None
  )(using Context): GetGrafanaGrafanaUserConfigAuthGitlabArgs =
    new GetGrafanaGrafanaUserConfigAuthGitlabArgs(
      allowSignUp = allowSignUp.asOptionOutput(isSecret = false),
      allowedGroups = allowedGroups.asOptionOutput(isSecret = false),
      apiUrl = apiUrl.asOptionOutput(isSecret = false),
      authUrl = authUrl.asOptionOutput(isSecret = false),
      clientId = clientId.asOutput(isSecret = false),
      clientSecret = clientSecret.asOutput(isSecret = false),
      tokenUrl = tokenUrl.asOptionOutput(isSecret = false)
    )
