package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetGrafanaGrafanaUserConfigAuthGoogleArgs private(
  allowSignUp: Output[Option[Boolean]],
  allowedDomains: Output[Option[scala.collection.immutable.List[String]]],
  clientId: Output[String],
  clientSecret: Output[String]
) derives Encoder, ArgsEncoder

object GetGrafanaGrafanaUserConfigAuthGoogleArgs:
  def apply(
    allowSignUp: Input.Optional[Boolean] = None,
    allowedDomains: Input.Optional[List[Input[String]]] = None,
    clientId: Input[String],
    clientSecret: Input[String]
  )(using Context): GetGrafanaGrafanaUserConfigAuthGoogleArgs =
    new GetGrafanaGrafanaUserConfigAuthGoogleArgs(
      allowSignUp = allowSignUp.asOptionOutput(isSecret = false),
      allowedDomains = allowedDomains.asOptionOutput(isSecret = false),
      clientId = clientId.asOutput(isSecret = false),
      clientSecret = clientSecret.asOutput(isSecret = false)
    )
