package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetGrafanaGrafanaUserConfigDateFormatsArgs private(
  defaultTimezone: Output[Option[String]],
  fullDate: Output[Option[String]],
  intervalDay: Output[Option[String]],
  intervalHour: Output[Option[String]],
  intervalMinute: Output[Option[String]],
  intervalMonth: Output[Option[String]],
  intervalSecond: Output[Option[String]],
  intervalYear: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetGrafanaGrafanaUserConfigDateFormatsArgs:
  def apply(
    defaultTimezone: Input.Optional[String] = None,
    fullDate: Input.Optional[String] = None,
    intervalDay: Input.Optional[String] = None,
    intervalHour: Input.Optional[String] = None,
    intervalMinute: Input.Optional[String] = None,
    intervalMonth: Input.Optional[String] = None,
    intervalSecond: Input.Optional[String] = None,
    intervalYear: Input.Optional[String] = None
  )(using Context): GetGrafanaGrafanaUserConfigDateFormatsArgs =
    new GetGrafanaGrafanaUserConfigDateFormatsArgs(
      defaultTimezone = defaultTimezone.asOptionOutput(isSecret = false),
      fullDate = fullDate.asOptionOutput(isSecret = false),
      intervalDay = intervalDay.asOptionOutput(isSecret = false),
      intervalHour = intervalHour.asOptionOutput(isSecret = false),
      intervalMinute = intervalMinute.asOptionOutput(isSecret = false),
      intervalMonth = intervalMonth.asOptionOutput(isSecret = false),
      intervalSecond = intervalSecond.asOptionOutput(isSecret = false),
      intervalYear = intervalYear.asOptionOutput(isSecret = false)
    )
