package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetGrafanaGrafanaUserConfigExternalImageStorageArgs private(
  accessKey: Output[String],
  bucketUrl: Output[String],
  provider: Output[String],
  secretKey: Output[String]
) derives Encoder, ArgsEncoder

object GetGrafanaGrafanaUserConfigExternalImageStorageArgs:
  def apply(
    accessKey: Input[String],
    bucketUrl: Input[String],
    provider: Input[String],
    secretKey: Input[String]
  )(using Context): GetGrafanaGrafanaUserConfigExternalImageStorageArgs =
    new GetGrafanaGrafanaUserConfigExternalImageStorageArgs(
      accessKey = accessKey.asOutput(isSecret = false),
      bucketUrl = bucketUrl.asOutput(isSecret = false),
      provider = provider.asOutput(isSecret = false),
      secretKey = secretKey.asOutput(isSecret = false)
    )
