package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetInfluxDbInfluxdbUserConfigArgs private(
  additionalBackupRegions: Output[Option[String]],
  customDomain: Output[Option[String]],
  influxdb: Output[Option[besom.api.aiven.inputs.GetInfluxDbInfluxdbUserConfigInfluxdbArgs]],
  ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.GetInfluxDbInfluxdbUserConfigIpFilterObjectArgs]]],
  ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]],
  ipFilters: Output[Option[scala.collection.immutable.List[String]]],
  privateAccess: Output[Option[besom.api.aiven.inputs.GetInfluxDbInfluxdbUserConfigPrivateAccessArgs]],
  privatelinkAccess: Output[Option[besom.api.aiven.inputs.GetInfluxDbInfluxdbUserConfigPrivatelinkAccessArgs]],
  projectToForkFrom: Output[Option[String]],
  publicAccess: Output[Option[besom.api.aiven.inputs.GetInfluxDbInfluxdbUserConfigPublicAccessArgs]],
  recoveryBasebackupName: Output[Option[String]],
  serviceToForkFrom: Output[Option[String]],
  staticIps: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetInfluxDbInfluxdbUserConfigArgs:
  def apply(
    additionalBackupRegions: Input.Optional[String] = None,
    customDomain: Input.Optional[String] = None,
    influxdb: Input.Optional[besom.api.aiven.inputs.GetInfluxDbInfluxdbUserConfigInfluxdbArgs] = None,
    ipFilterObjects: Input.Optional[List[Input[besom.api.aiven.inputs.GetInfluxDbInfluxdbUserConfigIpFilterObjectArgs]]] = None,
    ipFilterStrings: Input.Optional[List[Input[String]]] = None,
    ipFilters: Input.Optional[List[Input[String]]] = None,
    privateAccess: Input.Optional[besom.api.aiven.inputs.GetInfluxDbInfluxdbUserConfigPrivateAccessArgs] = None,
    privatelinkAccess: Input.Optional[besom.api.aiven.inputs.GetInfluxDbInfluxdbUserConfigPrivatelinkAccessArgs] = None,
    projectToForkFrom: Input.Optional[String] = None,
    publicAccess: Input.Optional[besom.api.aiven.inputs.GetInfluxDbInfluxdbUserConfigPublicAccessArgs] = None,
    recoveryBasebackupName: Input.Optional[String] = None,
    serviceToForkFrom: Input.Optional[String] = None,
    staticIps: Input.Optional[Boolean] = None
  )(using Context): GetInfluxDbInfluxdbUserConfigArgs =
    new GetInfluxDbInfluxdbUserConfigArgs(
      additionalBackupRegions = additionalBackupRegions.asOptionOutput(isSecret = false),
      customDomain = customDomain.asOptionOutput(isSecret = false),
      influxdb = influxdb.asOptionOutput(isSecret = false),
      ipFilterObjects = ipFilterObjects.asOptionOutput(isSecret = false),
      ipFilterStrings = ipFilterStrings.asOptionOutput(isSecret = false),
      ipFilters = ipFilters.asOptionOutput(isSecret = false),
      privateAccess = privateAccess.asOptionOutput(isSecret = false),
      privatelinkAccess = privatelinkAccess.asOptionOutput(isSecret = false),
      projectToForkFrom = projectToForkFrom.asOptionOutput(isSecret = false),
      publicAccess = publicAccess.asOptionOutput(isSecret = false),
      recoveryBasebackupName = recoveryBasebackupName.asOptionOutput(isSecret = false),
      serviceToForkFrom = serviceToForkFrom.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false)
    )
