package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetInfluxDbTagArgs private(
  key: Output[String],
  value: Output[String]
) derives Encoder, ArgsEncoder

object GetInfluxDbTagArgs:
  def apply(
    key: Input[String],
    value: Input[String]
  )(using Context): GetInfluxDbTagArgs =
    new GetInfluxDbTagArgs(
      key = key.asOutput(isSecret = false),
      value = value.asOutput(isSecret = false)
    )
