package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetKafkaConnectorTaskArgs private(
  connector: Output[String],
  task: Output[Int]
) derives Encoder, ArgsEncoder

object GetKafkaConnectorTaskArgs:
  def apply(
    connector: Input[String],
    task: Input[Int]
  )(using Context): GetKafkaConnectorTaskArgs =
    new GetKafkaConnectorTaskArgs(
      connector = connector.asOutput(isSecret = false),
      task = task.asOutput(isSecret = false)
    )
