package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetKafkaKafkaArgs private(
  accessCert: Output[String],
  accessKey: Output[String],
  connectUri: Output[String],
  restUri: Output[String],
  schemaRegistryUri: Output[String]
) derives Encoder, ArgsEncoder

object GetKafkaKafkaArgs:
  def apply(
    accessCert: Input[String],
    accessKey: Input[String],
    connectUri: Input[String],
    restUri: Input[String],
    schemaRegistryUri: Input[String]
  )(using Context): GetKafkaKafkaArgs =
    new GetKafkaKafkaArgs(
      accessCert = accessCert.asOutput(isSecret = true),
      accessKey = accessKey.asOutput(isSecret = true),
      connectUri = connectUri.asOutput(isSecret = true),
      restUri = restUri.asOutput(isSecret = true),
      schemaRegistryUri = schemaRegistryUri.asOutput(isSecret = true)
    )
