package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetKafkaKafkaUserConfigArgs private(
  additionalBackupRegions: Output[Option[String]],
  customDomain: Output[Option[String]],
  ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.GetKafkaKafkaUserConfigIpFilterObjectArgs]]],
  ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]],
  ipFilters: Output[Option[scala.collection.immutable.List[String]]],
  kafka: Output[Option[besom.api.aiven.inputs.GetKafkaKafkaUserConfigKafkaArgs]],
  kafkaAuthenticationMethods: Output[Option[besom.api.aiven.inputs.GetKafkaKafkaUserConfigKafkaAuthenticationMethodsArgs]],
  kafkaConnect: Output[Option[Boolean]],
  kafkaConnectConfig: Output[Option[besom.api.aiven.inputs.GetKafkaKafkaUserConfigKafkaConnectConfigArgs]],
  kafkaRest: Output[Option[Boolean]],
  kafkaRestAuthorization: Output[Option[Boolean]],
  kafkaRestConfig: Output[Option[besom.api.aiven.inputs.GetKafkaKafkaUserConfigKafkaRestConfigArgs]],
  kafkaVersion: Output[Option[String]],
  privateAccess: Output[Option[besom.api.aiven.inputs.GetKafkaKafkaUserConfigPrivateAccessArgs]],
  privatelinkAccess: Output[Option[besom.api.aiven.inputs.GetKafkaKafkaUserConfigPrivatelinkAccessArgs]],
  publicAccess: Output[Option[besom.api.aiven.inputs.GetKafkaKafkaUserConfigPublicAccessArgs]],
  schemaRegistry: Output[Option[Boolean]],
  schemaRegistryConfig: Output[Option[besom.api.aiven.inputs.GetKafkaKafkaUserConfigSchemaRegistryConfigArgs]],
  staticIps: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetKafkaKafkaUserConfigArgs:
  def apply(
    additionalBackupRegions: Input.Optional[String] = None,
    customDomain: Input.Optional[String] = None,
    ipFilterObjects: Input.Optional[List[Input[besom.api.aiven.inputs.GetKafkaKafkaUserConfigIpFilterObjectArgs]]] = None,
    ipFilterStrings: Input.Optional[List[Input[String]]] = None,
    ipFilters: Input.Optional[List[Input[String]]] = None,
    kafka: Input.Optional[besom.api.aiven.inputs.GetKafkaKafkaUserConfigKafkaArgs] = None,
    kafkaAuthenticationMethods: Input.Optional[besom.api.aiven.inputs.GetKafkaKafkaUserConfigKafkaAuthenticationMethodsArgs] = None,
    kafkaConnect: Input.Optional[Boolean] = None,
    kafkaConnectConfig: Input.Optional[besom.api.aiven.inputs.GetKafkaKafkaUserConfigKafkaConnectConfigArgs] = None,
    kafkaRest: Input.Optional[Boolean] = None,
    kafkaRestAuthorization: Input.Optional[Boolean] = None,
    kafkaRestConfig: Input.Optional[besom.api.aiven.inputs.GetKafkaKafkaUserConfigKafkaRestConfigArgs] = None,
    kafkaVersion: Input.Optional[String] = None,
    privateAccess: Input.Optional[besom.api.aiven.inputs.GetKafkaKafkaUserConfigPrivateAccessArgs] = None,
    privatelinkAccess: Input.Optional[besom.api.aiven.inputs.GetKafkaKafkaUserConfigPrivatelinkAccessArgs] = None,
    publicAccess: Input.Optional[besom.api.aiven.inputs.GetKafkaKafkaUserConfigPublicAccessArgs] = None,
    schemaRegistry: Input.Optional[Boolean] = None,
    schemaRegistryConfig: Input.Optional[besom.api.aiven.inputs.GetKafkaKafkaUserConfigSchemaRegistryConfigArgs] = None,
    staticIps: Input.Optional[Boolean] = None
  )(using Context): GetKafkaKafkaUserConfigArgs =
    new GetKafkaKafkaUserConfigArgs(
      additionalBackupRegions = additionalBackupRegions.asOptionOutput(isSecret = false),
      customDomain = customDomain.asOptionOutput(isSecret = false),
      ipFilterObjects = ipFilterObjects.asOptionOutput(isSecret = false),
      ipFilterStrings = ipFilterStrings.asOptionOutput(isSecret = false),
      ipFilters = ipFilters.asOptionOutput(isSecret = false),
      kafka = kafka.asOptionOutput(isSecret = false),
      kafkaAuthenticationMethods = kafkaAuthenticationMethods.asOptionOutput(isSecret = false),
      kafkaConnect = kafkaConnect.asOptionOutput(isSecret = false),
      kafkaConnectConfig = kafkaConnectConfig.asOptionOutput(isSecret = false),
      kafkaRest = kafkaRest.asOptionOutput(isSecret = false),
      kafkaRestAuthorization = kafkaRestAuthorization.asOptionOutput(isSecret = false),
      kafkaRestConfig = kafkaRestConfig.asOptionOutput(isSecret = false),
      kafkaVersion = kafkaVersion.asOptionOutput(isSecret = false),
      privateAccess = privateAccess.asOptionOutput(isSecret = false),
      privatelinkAccess = privatelinkAccess.asOptionOutput(isSecret = false),
      publicAccess = publicAccess.asOptionOutput(isSecret = false),
      schemaRegistry = schemaRegistry.asOptionOutput(isSecret = false),
      schemaRegistryConfig = schemaRegistryConfig.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false)
    )
