package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetKafkaKafkaUserConfigKafkaArgs private(
  autoCreateTopicsEnable: Output[Option[Boolean]],
  compressionType: Output[Option[String]],
  connectionsMaxIdleMs: Output[Option[Int]],
  defaultReplicationFactor: Output[Option[Int]],
  groupInitialRebalanceDelayMs: Output[Option[Int]],
  groupMaxSessionTimeoutMs: Output[Option[Int]],
  groupMinSessionTimeoutMs: Output[Option[Int]],
  logCleanerDeleteRetentionMs: Output[Option[Int]],
  logCleanerMaxCompactionLagMs: Output[Option[Int]],
  logCleanerMinCleanableRatio: Output[Option[Double]],
  logCleanerMinCompactionLagMs: Output[Option[Int]],
  logCleanupPolicy: Output[Option[String]],
  logFlushIntervalMessages: Output[Option[Int]],
  logFlushIntervalMs: Output[Option[Int]],
  logIndexIntervalBytes: Output[Option[Int]],
  logIndexSizeMaxBytes: Output[Option[Int]],
  logMessageDownconversionEnable: Output[Option[Boolean]],
  logMessageTimestampDifferenceMaxMs: Output[Option[Int]],
  logMessageTimestampType: Output[Option[String]],
  logPreallocate: Output[Option[Boolean]],
  logRetentionBytes: Output[Option[Int]],
  logRetentionHours: Output[Option[Int]],
  logRetentionMs: Output[Option[Int]],
  logRollJitterMs: Output[Option[Int]],
  logRollMs: Output[Option[Int]],
  logSegmentBytes: Output[Option[Int]],
  logSegmentDeleteDelayMs: Output[Option[Int]],
  maxConnectionsPerIp: Output[Option[Int]],
  maxIncrementalFetchSessionCacheSlots: Output[Option[Int]],
  messageMaxBytes: Output[Option[Int]],
  minInsyncReplicas: Output[Option[Int]],
  numPartitions: Output[Option[Int]],
  offsetsRetentionMinutes: Output[Option[Int]],
  producerPurgatoryPurgeIntervalRequests: Output[Option[Int]],
  replicaFetchMaxBytes: Output[Option[Int]],
  replicaFetchResponseMaxBytes: Output[Option[Int]],
  socketRequestMaxBytes: Output[Option[Int]],
  transactionRemoveExpiredTransactionCleanupIntervalMs: Output[Option[Int]],
  transactionStateLogSegmentBytes: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object GetKafkaKafkaUserConfigKafkaArgs:
  def apply(
    autoCreateTopicsEnable: Input.Optional[Boolean] = None,
    compressionType: Input.Optional[String] = None,
    connectionsMaxIdleMs: Input.Optional[Int] = None,
    defaultReplicationFactor: Input.Optional[Int] = None,
    groupInitialRebalanceDelayMs: Input.Optional[Int] = None,
    groupMaxSessionTimeoutMs: Input.Optional[Int] = None,
    groupMinSessionTimeoutMs: Input.Optional[Int] = None,
    logCleanerDeleteRetentionMs: Input.Optional[Int] = None,
    logCleanerMaxCompactionLagMs: Input.Optional[Int] = None,
    logCleanerMinCleanableRatio: Input.Optional[Double] = None,
    logCleanerMinCompactionLagMs: Input.Optional[Int] = None,
    logCleanupPolicy: Input.Optional[String] = None,
    logFlushIntervalMessages: Input.Optional[Int] = None,
    logFlushIntervalMs: Input.Optional[Int] = None,
    logIndexIntervalBytes: Input.Optional[Int] = None,
    logIndexSizeMaxBytes: Input.Optional[Int] = None,
    logMessageDownconversionEnable: Input.Optional[Boolean] = None,
    logMessageTimestampDifferenceMaxMs: Input.Optional[Int] = None,
    logMessageTimestampType: Input.Optional[String] = None,
    logPreallocate: Input.Optional[Boolean] = None,
    logRetentionBytes: Input.Optional[Int] = None,
    logRetentionHours: Input.Optional[Int] = None,
    logRetentionMs: Input.Optional[Int] = None,
    logRollJitterMs: Input.Optional[Int] = None,
    logRollMs: Input.Optional[Int] = None,
    logSegmentBytes: Input.Optional[Int] = None,
    logSegmentDeleteDelayMs: Input.Optional[Int] = None,
    maxConnectionsPerIp: Input.Optional[Int] = None,
    maxIncrementalFetchSessionCacheSlots: Input.Optional[Int] = None,
    messageMaxBytes: Input.Optional[Int] = None,
    minInsyncReplicas: Input.Optional[Int] = None,
    numPartitions: Input.Optional[Int] = None,
    offsetsRetentionMinutes: Input.Optional[Int] = None,
    producerPurgatoryPurgeIntervalRequests: Input.Optional[Int] = None,
    replicaFetchMaxBytes: Input.Optional[Int] = None,
    replicaFetchResponseMaxBytes: Input.Optional[Int] = None,
    socketRequestMaxBytes: Input.Optional[Int] = None,
    transactionRemoveExpiredTransactionCleanupIntervalMs: Input.Optional[Int] = None,
    transactionStateLogSegmentBytes: Input.Optional[Int] = None
  )(using Context): GetKafkaKafkaUserConfigKafkaArgs =
    new GetKafkaKafkaUserConfigKafkaArgs(
      autoCreateTopicsEnable = autoCreateTopicsEnable.asOptionOutput(isSecret = false),
      compressionType = compressionType.asOptionOutput(isSecret = false),
      connectionsMaxIdleMs = connectionsMaxIdleMs.asOptionOutput(isSecret = false),
      defaultReplicationFactor = defaultReplicationFactor.asOptionOutput(isSecret = false),
      groupInitialRebalanceDelayMs = groupInitialRebalanceDelayMs.asOptionOutput(isSecret = false),
      groupMaxSessionTimeoutMs = groupMaxSessionTimeoutMs.asOptionOutput(isSecret = false),
      groupMinSessionTimeoutMs = groupMinSessionTimeoutMs.asOptionOutput(isSecret = false),
      logCleanerDeleteRetentionMs = logCleanerDeleteRetentionMs.asOptionOutput(isSecret = false),
      logCleanerMaxCompactionLagMs = logCleanerMaxCompactionLagMs.asOptionOutput(isSecret = false),
      logCleanerMinCleanableRatio = logCleanerMinCleanableRatio.asOptionOutput(isSecret = false),
      logCleanerMinCompactionLagMs = logCleanerMinCompactionLagMs.asOptionOutput(isSecret = false),
      logCleanupPolicy = logCleanupPolicy.asOptionOutput(isSecret = false),
      logFlushIntervalMessages = logFlushIntervalMessages.asOptionOutput(isSecret = false),
      logFlushIntervalMs = logFlushIntervalMs.asOptionOutput(isSecret = false),
      logIndexIntervalBytes = logIndexIntervalBytes.asOptionOutput(isSecret = false),
      logIndexSizeMaxBytes = logIndexSizeMaxBytes.asOptionOutput(isSecret = false),
      logMessageDownconversionEnable = logMessageDownconversionEnable.asOptionOutput(isSecret = false),
      logMessageTimestampDifferenceMaxMs = logMessageTimestampDifferenceMaxMs.asOptionOutput(isSecret = false),
      logMessageTimestampType = logMessageTimestampType.asOptionOutput(isSecret = false),
      logPreallocate = logPreallocate.asOptionOutput(isSecret = false),
      logRetentionBytes = logRetentionBytes.asOptionOutput(isSecret = false),
      logRetentionHours = logRetentionHours.asOptionOutput(isSecret = false),
      logRetentionMs = logRetentionMs.asOptionOutput(isSecret = false),
      logRollJitterMs = logRollJitterMs.asOptionOutput(isSecret = false),
      logRollMs = logRollMs.asOptionOutput(isSecret = false),
      logSegmentBytes = logSegmentBytes.asOptionOutput(isSecret = false),
      logSegmentDeleteDelayMs = logSegmentDeleteDelayMs.asOptionOutput(isSecret = false),
      maxConnectionsPerIp = maxConnectionsPerIp.asOptionOutput(isSecret = false),
      maxIncrementalFetchSessionCacheSlots = maxIncrementalFetchSessionCacheSlots.asOptionOutput(isSecret = false),
      messageMaxBytes = messageMaxBytes.asOptionOutput(isSecret = false),
      minInsyncReplicas = minInsyncReplicas.asOptionOutput(isSecret = false),
      numPartitions = numPartitions.asOptionOutput(isSecret = false),
      offsetsRetentionMinutes = offsetsRetentionMinutes.asOptionOutput(isSecret = false),
      producerPurgatoryPurgeIntervalRequests = producerPurgatoryPurgeIntervalRequests.asOptionOutput(isSecret = false),
      replicaFetchMaxBytes = replicaFetchMaxBytes.asOptionOutput(isSecret = false),
      replicaFetchResponseMaxBytes = replicaFetchResponseMaxBytes.asOptionOutput(isSecret = false),
      socketRequestMaxBytes = socketRequestMaxBytes.asOptionOutput(isSecret = false),
      transactionRemoveExpiredTransactionCleanupIntervalMs = transactionRemoveExpiredTransactionCleanupIntervalMs.asOptionOutput(isSecret = false),
      transactionStateLogSegmentBytes = transactionStateLogSegmentBytes.asOptionOutput(isSecret = false)
    )
