package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetKafkaKafkaUserConfigPrivatelinkAccessArgs private(
  jolokia: Output[Option[Boolean]],
  kafka: Output[Option[Boolean]],
  kafkaConnect: Output[Option[Boolean]],
  kafkaRest: Output[Option[Boolean]],
  prometheus: Output[Option[Boolean]],
  schemaRegistry: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetKafkaKafkaUserConfigPrivatelinkAccessArgs:
  def apply(
    jolokia: Input.Optional[Boolean] = None,
    kafka: Input.Optional[Boolean] = None,
    kafkaConnect: Input.Optional[Boolean] = None,
    kafkaRest: Input.Optional[Boolean] = None,
    prometheus: Input.Optional[Boolean] = None,
    schemaRegistry: Input.Optional[Boolean] = None
  )(using Context): GetKafkaKafkaUserConfigPrivatelinkAccessArgs =
    new GetKafkaKafkaUserConfigPrivatelinkAccessArgs(
      jolokia = jolokia.asOptionOutput(isSecret = false),
      kafka = kafka.asOptionOutput(isSecret = false),
      kafkaConnect = kafkaConnect.asOptionOutput(isSecret = false),
      kafkaRest = kafkaRest.asOptionOutput(isSecret = false),
      prometheus = prometheus.asOptionOutput(isSecret = false),
      schemaRegistry = schemaRegistry.asOptionOutput(isSecret = false)
    )
