package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetKafkaMirrorMakerTagArgs private(
  key: Output[String],
  value: Output[String]
) derives Encoder, ArgsEncoder

object GetKafkaMirrorMakerTagArgs:
  def apply(
    key: Input[String],
    value: Input[String]
  )(using Context): GetKafkaMirrorMakerTagArgs =
    new GetKafkaMirrorMakerTagArgs(
      key = key.asOutput(isSecret = false),
      value = value.asOutput(isSecret = false)
    )
