package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetKafkaTopicTagArgs private(
  key: Output[String],
  value: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetKafkaTopicTagArgs:
  def apply(
    key: Input[String],
    value: Input.Optional[String] = None
  )(using Context): GetKafkaTopicTagArgs =
    new GetKafkaTopicTagArgs(
      key = key.asOutput(isSecret = false),
      value = value.asOptionOutput(isSecret = false)
    )
