package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetM3AggregatorM3aggregatorUserConfigArgs private(
  customDomain: Output[Option[String]],
  ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.GetM3AggregatorM3aggregatorUserConfigIpFilterObjectArgs]]],
  ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]],
  ipFilters: Output[Option[scala.collection.immutable.List[String]]],
  m3Version: Output[Option[String]],
  m3aggregatorVersion: Output[Option[String]],
  staticIps: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetM3AggregatorM3aggregatorUserConfigArgs:
  def apply(
    customDomain: Input.Optional[String] = None,
    ipFilterObjects: Input.Optional[List[Input[besom.api.aiven.inputs.GetM3AggregatorM3aggregatorUserConfigIpFilterObjectArgs]]] = None,
    ipFilterStrings: Input.Optional[List[Input[String]]] = None,
    ipFilters: Input.Optional[List[Input[String]]] = None,
    m3Version: Input.Optional[String] = None,
    m3aggregatorVersion: Input.Optional[String] = None,
    staticIps: Input.Optional[Boolean] = None
  )(using Context): GetM3AggregatorM3aggregatorUserConfigArgs =
    new GetM3AggregatorM3aggregatorUserConfigArgs(
      customDomain = customDomain.asOptionOutput(isSecret = false),
      ipFilterObjects = ipFilterObjects.asOptionOutput(isSecret = false),
      ipFilterStrings = ipFilterStrings.asOptionOutput(isSecret = false),
      ipFilters = ipFilters.asOptionOutput(isSecret = false),
      m3Version = m3Version.asOptionOutput(isSecret = false),
      m3aggregatorVersion = m3aggregatorVersion.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false)
    )
