package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetM3AggregatorTagArgs private(
  key: Output[String],
  value: Output[String]
) derives Encoder, ArgsEncoder

object GetM3AggregatorTagArgs:
  def apply(
    key: Input[String],
    value: Input[String]
  )(using Context): GetM3AggregatorTagArgs =
    new GetM3AggregatorTagArgs(
      key = key.asOutput(isSecret = false),
      value = value.asOutput(isSecret = false)
    )
