package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetM3DbM3dbUserConfigLimitsArgs private(
  maxRecentlyQueriedSeriesBlocks: Output[Option[Int]],
  maxRecentlyQueriedSeriesDiskBytesRead: Output[Option[Int]],
  maxRecentlyQueriedSeriesLookback: Output[Option[String]],
  queryDocs: Output[Option[Int]],
  queryRequireExhaustive: Output[Option[Boolean]],
  querySeries: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object GetM3DbM3dbUserConfigLimitsArgs:
  def apply(
    maxRecentlyQueriedSeriesBlocks: Input.Optional[Int] = None,
    maxRecentlyQueriedSeriesDiskBytesRead: Input.Optional[Int] = None,
    maxRecentlyQueriedSeriesLookback: Input.Optional[String] = None,
    queryDocs: Input.Optional[Int] = None,
    queryRequireExhaustive: Input.Optional[Boolean] = None,
    querySeries: Input.Optional[Int] = None
  )(using Context): GetM3DbM3dbUserConfigLimitsArgs =
    new GetM3DbM3dbUserConfigLimitsArgs(
      maxRecentlyQueriedSeriesBlocks = maxRecentlyQueriedSeriesBlocks.asOptionOutput(isSecret = false),
      maxRecentlyQueriedSeriesDiskBytesRead = maxRecentlyQueriedSeriesDiskBytesRead.asOptionOutput(isSecret = false),
      maxRecentlyQueriedSeriesLookback = maxRecentlyQueriedSeriesLookback.asOptionOutput(isSecret = false),
      queryDocs = queryDocs.asOptionOutput(isSecret = false),
      queryRequireExhaustive = queryRequireExhaustive.asOptionOutput(isSecret = false),
      querySeries = querySeries.asOptionOutput(isSecret = false)
    )
