package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetMySqlMysqlUserConfigArgs private(
  additionalBackupRegions: Output[Option[String]],
  adminPassword: Output[Option[String]],
  adminUsername: Output[Option[String]],
  backupHour: Output[Option[Int]],
  backupMinute: Output[Option[Int]],
  binlogRetentionPeriod: Output[Option[Int]],
  ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.GetMySqlMysqlUserConfigIpFilterObjectArgs]]],
  ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]],
  ipFilters: Output[Option[scala.collection.immutable.List[String]]],
  migration: Output[Option[besom.api.aiven.inputs.GetMySqlMysqlUserConfigMigrationArgs]],
  mysql: Output[Option[besom.api.aiven.inputs.GetMySqlMysqlUserConfigMysqlArgs]],
  mysqlVersion: Output[Option[String]],
  privateAccess: Output[Option[besom.api.aiven.inputs.GetMySqlMysqlUserConfigPrivateAccessArgs]],
  privatelinkAccess: Output[Option[besom.api.aiven.inputs.GetMySqlMysqlUserConfigPrivatelinkAccessArgs]],
  projectToForkFrom: Output[Option[String]],
  publicAccess: Output[Option[besom.api.aiven.inputs.GetMySqlMysqlUserConfigPublicAccessArgs]],
  recoveryTargetTime: Output[Option[String]],
  serviceToForkFrom: Output[Option[String]],
  staticIps: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetMySqlMysqlUserConfigArgs:
  def apply(
    additionalBackupRegions: Input.Optional[String] = None,
    adminPassword: Input.Optional[String] = None,
    adminUsername: Input.Optional[String] = None,
    backupHour: Input.Optional[Int] = None,
    backupMinute: Input.Optional[Int] = None,
    binlogRetentionPeriod: Input.Optional[Int] = None,
    ipFilterObjects: Input.Optional[List[Input[besom.api.aiven.inputs.GetMySqlMysqlUserConfigIpFilterObjectArgs]]] = None,
    ipFilterStrings: Input.Optional[List[Input[String]]] = None,
    ipFilters: Input.Optional[List[Input[String]]] = None,
    migration: Input.Optional[besom.api.aiven.inputs.GetMySqlMysqlUserConfigMigrationArgs] = None,
    mysql: Input.Optional[besom.api.aiven.inputs.GetMySqlMysqlUserConfigMysqlArgs] = None,
    mysqlVersion: Input.Optional[String] = None,
    privateAccess: Input.Optional[besom.api.aiven.inputs.GetMySqlMysqlUserConfigPrivateAccessArgs] = None,
    privatelinkAccess: Input.Optional[besom.api.aiven.inputs.GetMySqlMysqlUserConfigPrivatelinkAccessArgs] = None,
    projectToForkFrom: Input.Optional[String] = None,
    publicAccess: Input.Optional[besom.api.aiven.inputs.GetMySqlMysqlUserConfigPublicAccessArgs] = None,
    recoveryTargetTime: Input.Optional[String] = None,
    serviceToForkFrom: Input.Optional[String] = None,
    staticIps: Input.Optional[Boolean] = None
  )(using Context): GetMySqlMysqlUserConfigArgs =
    new GetMySqlMysqlUserConfigArgs(
      additionalBackupRegions = additionalBackupRegions.asOptionOutput(isSecret = false),
      adminPassword = adminPassword.asOptionOutput(isSecret = true),
      adminUsername = adminUsername.asOptionOutput(isSecret = false),
      backupHour = backupHour.asOptionOutput(isSecret = false),
      backupMinute = backupMinute.asOptionOutput(isSecret = false),
      binlogRetentionPeriod = binlogRetentionPeriod.asOptionOutput(isSecret = false),
      ipFilterObjects = ipFilterObjects.asOptionOutput(isSecret = false),
      ipFilterStrings = ipFilterStrings.asOptionOutput(isSecret = false),
      ipFilters = ipFilters.asOptionOutput(isSecret = false),
      migration = migration.asOptionOutput(isSecret = false),
      mysql = mysql.asOptionOutput(isSecret = false),
      mysqlVersion = mysqlVersion.asOptionOutput(isSecret = false),
      privateAccess = privateAccess.asOptionOutput(isSecret = false),
      privatelinkAccess = privatelinkAccess.asOptionOutput(isSecret = false),
      projectToForkFrom = projectToForkFrom.asOptionOutput(isSecret = false),
      publicAccess = publicAccess.asOptionOutput(isSecret = false),
      recoveryTargetTime = recoveryTargetTime.asOptionOutput(isSecret = false),
      serviceToForkFrom = serviceToForkFrom.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false)
    )
