package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetMySqlMysqlUserConfigMysqlArgs private(
  connectTimeout: Output[Option[Int]],
  defaultTimeZone: Output[Option[String]],
  groupConcatMaxLen: Output[Option[Int]],
  informationSchemaStatsExpiry: Output[Option[Int]],
  innodbChangeBufferMaxSize: Output[Option[Int]],
  innodbFlushNeighbors: Output[Option[Int]],
  innodbFtMinTokenSize: Output[Option[Int]],
  innodbFtServerStopwordTable: Output[Option[String]],
  innodbLockWaitTimeout: Output[Option[Int]],
  innodbLogBufferSize: Output[Option[Int]],
  innodbOnlineAlterLogMaxSize: Output[Option[Int]],
  innodbPrintAllDeadlocks: Output[Option[Boolean]],
  innodbReadIoThreads: Output[Option[Int]],
  innodbRollbackOnTimeout: Output[Option[Boolean]],
  innodbThreadConcurrency: Output[Option[Int]],
  innodbWriteIoThreads: Output[Option[Int]],
  interactiveTimeout: Output[Option[Int]],
  internalTmpMemStorageEngine: Output[Option[String]],
  longQueryTime: Output[Option[Double]],
  maxAllowedPacket: Output[Option[Int]],
  maxHeapTableSize: Output[Option[Int]],
  netBufferLength: Output[Option[Int]],
  netReadTimeout: Output[Option[Int]],
  netWriteTimeout: Output[Option[Int]],
  slowQueryLog: Output[Option[Boolean]],
  sortBufferSize: Output[Option[Int]],
  sqlMode: Output[Option[String]],
  sqlRequirePrimaryKey: Output[Option[Boolean]],
  tmpTableSize: Output[Option[Int]],
  waitTimeout: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object GetMySqlMysqlUserConfigMysqlArgs:
  def apply(
    connectTimeout: Input.Optional[Int] = None,
    defaultTimeZone: Input.Optional[String] = None,
    groupConcatMaxLen: Input.Optional[Int] = None,
    informationSchemaStatsExpiry: Input.Optional[Int] = None,
    innodbChangeBufferMaxSize: Input.Optional[Int] = None,
    innodbFlushNeighbors: Input.Optional[Int] = None,
    innodbFtMinTokenSize: Input.Optional[Int] = None,
    innodbFtServerStopwordTable: Input.Optional[String] = None,
    innodbLockWaitTimeout: Input.Optional[Int] = None,
    innodbLogBufferSize: Input.Optional[Int] = None,
    innodbOnlineAlterLogMaxSize: Input.Optional[Int] = None,
    innodbPrintAllDeadlocks: Input.Optional[Boolean] = None,
    innodbReadIoThreads: Input.Optional[Int] = None,
    innodbRollbackOnTimeout: Input.Optional[Boolean] = None,
    innodbThreadConcurrency: Input.Optional[Int] = None,
    innodbWriteIoThreads: Input.Optional[Int] = None,
    interactiveTimeout: Input.Optional[Int] = None,
    internalTmpMemStorageEngine: Input.Optional[String] = None,
    longQueryTime: Input.Optional[Double] = None,
    maxAllowedPacket: Input.Optional[Int] = None,
    maxHeapTableSize: Input.Optional[Int] = None,
    netBufferLength: Input.Optional[Int] = None,
    netReadTimeout: Input.Optional[Int] = None,
    netWriteTimeout: Input.Optional[Int] = None,
    slowQueryLog: Input.Optional[Boolean] = None,
    sortBufferSize: Input.Optional[Int] = None,
    sqlMode: Input.Optional[String] = None,
    sqlRequirePrimaryKey: Input.Optional[Boolean] = None,
    tmpTableSize: Input.Optional[Int] = None,
    waitTimeout: Input.Optional[Int] = None
  )(using Context): GetMySqlMysqlUserConfigMysqlArgs =
    new GetMySqlMysqlUserConfigMysqlArgs(
      connectTimeout = connectTimeout.asOptionOutput(isSecret = false),
      defaultTimeZone = defaultTimeZone.asOptionOutput(isSecret = false),
      groupConcatMaxLen = groupConcatMaxLen.asOptionOutput(isSecret = false),
      informationSchemaStatsExpiry = informationSchemaStatsExpiry.asOptionOutput(isSecret = false),
      innodbChangeBufferMaxSize = innodbChangeBufferMaxSize.asOptionOutput(isSecret = false),
      innodbFlushNeighbors = innodbFlushNeighbors.asOptionOutput(isSecret = false),
      innodbFtMinTokenSize = innodbFtMinTokenSize.asOptionOutput(isSecret = false),
      innodbFtServerStopwordTable = innodbFtServerStopwordTable.asOptionOutput(isSecret = false),
      innodbLockWaitTimeout = innodbLockWaitTimeout.asOptionOutput(isSecret = false),
      innodbLogBufferSize = innodbLogBufferSize.asOptionOutput(isSecret = false),
      innodbOnlineAlterLogMaxSize = innodbOnlineAlterLogMaxSize.asOptionOutput(isSecret = false),
      innodbPrintAllDeadlocks = innodbPrintAllDeadlocks.asOptionOutput(isSecret = false),
      innodbReadIoThreads = innodbReadIoThreads.asOptionOutput(isSecret = false),
      innodbRollbackOnTimeout = innodbRollbackOnTimeout.asOptionOutput(isSecret = false),
      innodbThreadConcurrency = innodbThreadConcurrency.asOptionOutput(isSecret = false),
      innodbWriteIoThreads = innodbWriteIoThreads.asOptionOutput(isSecret = false),
      interactiveTimeout = interactiveTimeout.asOptionOutput(isSecret = false),
      internalTmpMemStorageEngine = internalTmpMemStorageEngine.asOptionOutput(isSecret = false),
      longQueryTime = longQueryTime.asOptionOutput(isSecret = false),
      maxAllowedPacket = maxAllowedPacket.asOptionOutput(isSecret = false),
      maxHeapTableSize = maxHeapTableSize.asOptionOutput(isSecret = false),
      netBufferLength = netBufferLength.asOptionOutput(isSecret = false),
      netReadTimeout = netReadTimeout.asOptionOutput(isSecret = false),
      netWriteTimeout = netWriteTimeout.asOptionOutput(isSecret = false),
      slowQueryLog = slowQueryLog.asOptionOutput(isSecret = false),
      sortBufferSize = sortBufferSize.asOptionOutput(isSecret = false),
      sqlMode = sqlMode.asOptionOutput(isSecret = false),
      sqlRequirePrimaryKey = sqlRequirePrimaryKey.asOptionOutput(isSecret = false),
      tmpTableSize = tmpTableSize.asOptionOutput(isSecret = false),
      waitTimeout = waitTimeout.asOptionOutput(isSecret = false)
    )
