package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetMySqlMysqlUserConfigPrivateAccessArgs private(
  mysql: Output[Option[Boolean]],
  mysqlx: Output[Option[Boolean]],
  prometheus: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetMySqlMysqlUserConfigPrivateAccessArgs:
  def apply(
    mysql: Input.Optional[Boolean] = None,
    mysqlx: Input.Optional[Boolean] = None,
    prometheus: Input.Optional[Boolean] = None
  )(using Context): GetMySqlMysqlUserConfigPrivateAccessArgs =
    new GetMySqlMysqlUserConfigPrivateAccessArgs(
      mysql = mysql.asOptionOutput(isSecret = false),
      mysqlx = mysqlx.asOptionOutput(isSecret = false),
      prometheus = prometheus.asOptionOutput(isSecret = false)
    )
