package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetOpenSearchOpensearchArgs private(
  opensearchDashboardsUri: Output[String]
) derives Encoder, ArgsEncoder

object GetOpenSearchOpensearchArgs:
  def apply(
    opensearchDashboardsUri: Input[String]
  )(using Context): GetOpenSearchOpensearchArgs =
    new GetOpenSearchOpensearchArgs(
      opensearchDashboardsUri = opensearchDashboardsUri.asOutput(isSecret = true)
    )
