package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetOpenSearchOpensearchUserConfigArgs private(
  additionalBackupRegions: Output[Option[String]],
  customDomain: Output[Option[String]],
  disableReplicationFactorAdjustment: Output[Option[Boolean]],
  indexPatterns: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigIndexPatternArgs]]],
  indexTemplate: Output[Option[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigIndexTemplateArgs]],
  ipFilterObjects: Output[Option[scala.collection.immutable.List[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigIpFilterObjectArgs]]],
  ipFilterStrings: Output[Option[scala.collection.immutable.List[String]]],
  ipFilters: Output[Option[scala.collection.immutable.List[String]]],
  keepIndexRefreshInterval: Output[Option[Boolean]],
  maxIndexCount: Output[Option[Int]],
  openid: Output[Option[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigOpenidArgs]],
  opensearch: Output[Option[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigOpensearchArgs]],
  opensearchDashboards: Output[Option[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigOpensearchDashboardsArgs]],
  opensearchVersion: Output[Option[String]],
  privateAccess: Output[Option[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigPrivateAccessArgs]],
  privatelinkAccess: Output[Option[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigPrivatelinkAccessArgs]],
  projectToForkFrom: Output[Option[String]],
  publicAccess: Output[Option[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigPublicAccessArgs]],
  recoveryBasebackupName: Output[Option[String]],
  saml: Output[Option[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigSamlArgs]],
  serviceToForkFrom: Output[Option[String]],
  staticIps: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetOpenSearchOpensearchUserConfigArgs:
  def apply(
    additionalBackupRegions: Input.Optional[String] = None,
    customDomain: Input.Optional[String] = None,
    disableReplicationFactorAdjustment: Input.Optional[Boolean] = None,
    indexPatterns: Input.Optional[List[Input[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigIndexPatternArgs]]] = None,
    indexTemplate: Input.Optional[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigIndexTemplateArgs] = None,
    ipFilterObjects: Input.Optional[List[Input[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigIpFilterObjectArgs]]] = None,
    ipFilterStrings: Input.Optional[List[Input[String]]] = None,
    ipFilters: Input.Optional[List[Input[String]]] = None,
    keepIndexRefreshInterval: Input.Optional[Boolean] = None,
    maxIndexCount: Input.Optional[Int] = None,
    openid: Input.Optional[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigOpenidArgs] = None,
    opensearch: Input.Optional[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigOpensearchArgs] = None,
    opensearchDashboards: Input.Optional[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigOpensearchDashboardsArgs] = None,
    opensearchVersion: Input.Optional[String] = None,
    privateAccess: Input.Optional[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigPrivateAccessArgs] = None,
    privatelinkAccess: Input.Optional[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigPrivatelinkAccessArgs] = None,
    projectToForkFrom: Input.Optional[String] = None,
    publicAccess: Input.Optional[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigPublicAccessArgs] = None,
    recoveryBasebackupName: Input.Optional[String] = None,
    saml: Input.Optional[besom.api.aiven.inputs.GetOpenSearchOpensearchUserConfigSamlArgs] = None,
    serviceToForkFrom: Input.Optional[String] = None,
    staticIps: Input.Optional[Boolean] = None
  )(using Context): GetOpenSearchOpensearchUserConfigArgs =
    new GetOpenSearchOpensearchUserConfigArgs(
      additionalBackupRegions = additionalBackupRegions.asOptionOutput(isSecret = false),
      customDomain = customDomain.asOptionOutput(isSecret = false),
      disableReplicationFactorAdjustment = disableReplicationFactorAdjustment.asOptionOutput(isSecret = false),
      indexPatterns = indexPatterns.asOptionOutput(isSecret = false),
      indexTemplate = indexTemplate.asOptionOutput(isSecret = false),
      ipFilterObjects = ipFilterObjects.asOptionOutput(isSecret = false),
      ipFilterStrings = ipFilterStrings.asOptionOutput(isSecret = false),
      ipFilters = ipFilters.asOptionOutput(isSecret = false),
      keepIndexRefreshInterval = keepIndexRefreshInterval.asOptionOutput(isSecret = false),
      maxIndexCount = maxIndexCount.asOptionOutput(isSecret = false),
      openid = openid.asOptionOutput(isSecret = false),
      opensearch = opensearch.asOptionOutput(isSecret = false),
      opensearchDashboards = opensearchDashboards.asOptionOutput(isSecret = false),
      opensearchVersion = opensearchVersion.asOptionOutput(isSecret = false),
      privateAccess = privateAccess.asOptionOutput(isSecret = false),
      privatelinkAccess = privatelinkAccess.asOptionOutput(isSecret = false),
      projectToForkFrom = projectToForkFrom.asOptionOutput(isSecret = false),
      publicAccess = publicAccess.asOptionOutput(isSecret = false),
      recoveryBasebackupName = recoveryBasebackupName.asOptionOutput(isSecret = false),
      saml = saml.asOptionOutput(isSecret = false),
      serviceToForkFrom = serviceToForkFrom.asOptionOutput(isSecret = false),
      staticIps = staticIps.asOptionOutput(isSecret = false)
    )
