package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetOpenSearchOpensearchUserConfigIndexPatternArgs private(
  maxIndexCount: Output[Int],
  pattern: Output[String],
  sortingAlgorithm: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetOpenSearchOpensearchUserConfigIndexPatternArgs:
  def apply(
    maxIndexCount: Input[Int],
    pattern: Input[String],
    sortingAlgorithm: Input.Optional[String] = None
  )(using Context): GetOpenSearchOpensearchUserConfigIndexPatternArgs =
    new GetOpenSearchOpensearchUserConfigIndexPatternArgs(
      maxIndexCount = maxIndexCount.asOutput(isSecret = false),
      pattern = pattern.asOutput(isSecret = false),
      sortingAlgorithm = sortingAlgorithm.asOptionOutput(isSecret = false)
    )
