package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetOpenSearchOpensearchUserConfigIpFilterObjectArgs private(
  description: Output[Option[String]],
  network: Output[String]
) derives Encoder, ArgsEncoder

object GetOpenSearchOpensearchUserConfigIpFilterObjectArgs:
  def apply(
    description: Input.Optional[String] = None,
    network: Input[String]
  )(using Context): GetOpenSearchOpensearchUserConfigIpFilterObjectArgs =
    new GetOpenSearchOpensearchUserConfigIpFilterObjectArgs(
      description = description.asOptionOutput(isSecret = false),
      network = network.asOutput(isSecret = false)
    )
