package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetOpenSearchOpensearchUserConfigOpensearchArgs private(
  actionAutoCreateIndexEnabled: Output[Option[Boolean]],
  actionDestructiveRequiresName: Output[Option[Boolean]],
  clusterMaxShardsPerNode: Output[Option[Int]],
  clusterRoutingAllocationNodeConcurrentRecoveries: Output[Option[Int]],
  emailSenderName: Output[Option[String]],
  emailSenderPassword: Output[Option[String]],
  emailSenderUsername: Output[Option[String]],
  httpMaxContentLength: Output[Option[Int]],
  httpMaxHeaderSize: Output[Option[Int]],
  httpMaxInitialLineLength: Output[Option[Int]],
  indicesFielddataCacheSize: Output[Option[Int]],
  indicesMemoryIndexBufferSize: Output[Option[Int]],
  indicesQueriesCacheSize: Output[Option[Int]],
  indicesQueryBoolMaxClauseCount: Output[Option[Int]],
  indicesRecoveryMaxBytesPerSec: Output[Option[Int]],
  indicesRecoveryMaxConcurrentFileChunks: Output[Option[Int]],
  overrideMainResponseVersion: Output[Option[Boolean]],
  reindexRemoteWhitelists: Output[Option[scala.collection.immutable.List[String]]],
  scriptMaxCompilationsRate: Output[Option[String]],
  searchMaxBuckets: Output[Option[Int]],
  threadPoolAnalyzeQueueSize: Output[Option[Int]],
  threadPoolAnalyzeSize: Output[Option[Int]],
  threadPoolForceMergeSize: Output[Option[Int]],
  threadPoolGetQueueSize: Output[Option[Int]],
  threadPoolGetSize: Output[Option[Int]],
  threadPoolSearchQueueSize: Output[Option[Int]],
  threadPoolSearchSize: Output[Option[Int]],
  threadPoolSearchThrottledQueueSize: Output[Option[Int]],
  threadPoolSearchThrottledSize: Output[Option[Int]],
  threadPoolWriteQueueSize: Output[Option[Int]],
  threadPoolWriteSize: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object GetOpenSearchOpensearchUserConfigOpensearchArgs:
  def apply(
    actionAutoCreateIndexEnabled: Input.Optional[Boolean] = None,
    actionDestructiveRequiresName: Input.Optional[Boolean] = None,
    clusterMaxShardsPerNode: Input.Optional[Int] = None,
    clusterRoutingAllocationNodeConcurrentRecoveries: Input.Optional[Int] = None,
    emailSenderName: Input.Optional[String] = None,
    emailSenderPassword: Input.Optional[String] = None,
    emailSenderUsername: Input.Optional[String] = None,
    httpMaxContentLength: Input.Optional[Int] = None,
    httpMaxHeaderSize: Input.Optional[Int] = None,
    httpMaxInitialLineLength: Input.Optional[Int] = None,
    indicesFielddataCacheSize: Input.Optional[Int] = None,
    indicesMemoryIndexBufferSize: Input.Optional[Int] = None,
    indicesQueriesCacheSize: Input.Optional[Int] = None,
    indicesQueryBoolMaxClauseCount: Input.Optional[Int] = None,
    indicesRecoveryMaxBytesPerSec: Input.Optional[Int] = None,
    indicesRecoveryMaxConcurrentFileChunks: Input.Optional[Int] = None,
    overrideMainResponseVersion: Input.Optional[Boolean] = None,
    reindexRemoteWhitelists: Input.Optional[List[Input[String]]] = None,
    scriptMaxCompilationsRate: Input.Optional[String] = None,
    searchMaxBuckets: Input.Optional[Int] = None,
    threadPoolAnalyzeQueueSize: Input.Optional[Int] = None,
    threadPoolAnalyzeSize: Input.Optional[Int] = None,
    threadPoolForceMergeSize: Input.Optional[Int] = None,
    threadPoolGetQueueSize: Input.Optional[Int] = None,
    threadPoolGetSize: Input.Optional[Int] = None,
    threadPoolSearchQueueSize: Input.Optional[Int] = None,
    threadPoolSearchSize: Input.Optional[Int] = None,
    threadPoolSearchThrottledQueueSize: Input.Optional[Int] = None,
    threadPoolSearchThrottledSize: Input.Optional[Int] = None,
    threadPoolWriteQueueSize: Input.Optional[Int] = None,
    threadPoolWriteSize: Input.Optional[Int] = None
  )(using Context): GetOpenSearchOpensearchUserConfigOpensearchArgs =
    new GetOpenSearchOpensearchUserConfigOpensearchArgs(
      actionAutoCreateIndexEnabled = actionAutoCreateIndexEnabled.asOptionOutput(isSecret = false),
      actionDestructiveRequiresName = actionDestructiveRequiresName.asOptionOutput(isSecret = false),
      clusterMaxShardsPerNode = clusterMaxShardsPerNode.asOptionOutput(isSecret = false),
      clusterRoutingAllocationNodeConcurrentRecoveries = clusterRoutingAllocationNodeConcurrentRecoveries.asOptionOutput(isSecret = false),
      emailSenderName = emailSenderName.asOptionOutput(isSecret = false),
      emailSenderPassword = emailSenderPassword.asOptionOutput(isSecret = true),
      emailSenderUsername = emailSenderUsername.asOptionOutput(isSecret = false),
      httpMaxContentLength = httpMaxContentLength.asOptionOutput(isSecret = false),
      httpMaxHeaderSize = httpMaxHeaderSize.asOptionOutput(isSecret = false),
      httpMaxInitialLineLength = httpMaxInitialLineLength.asOptionOutput(isSecret = false),
      indicesFielddataCacheSize = indicesFielddataCacheSize.asOptionOutput(isSecret = false),
      indicesMemoryIndexBufferSize = indicesMemoryIndexBufferSize.asOptionOutput(isSecret = false),
      indicesQueriesCacheSize = indicesQueriesCacheSize.asOptionOutput(isSecret = false),
      indicesQueryBoolMaxClauseCount = indicesQueryBoolMaxClauseCount.asOptionOutput(isSecret = false),
      indicesRecoveryMaxBytesPerSec = indicesRecoveryMaxBytesPerSec.asOptionOutput(isSecret = false),
      indicesRecoveryMaxConcurrentFileChunks = indicesRecoveryMaxConcurrentFileChunks.asOptionOutput(isSecret = false),
      overrideMainResponseVersion = overrideMainResponseVersion.asOptionOutput(isSecret = false),
      reindexRemoteWhitelists = reindexRemoteWhitelists.asOptionOutput(isSecret = false),
      scriptMaxCompilationsRate = scriptMaxCompilationsRate.asOptionOutput(isSecret = false),
      searchMaxBuckets = searchMaxBuckets.asOptionOutput(isSecret = false),
      threadPoolAnalyzeQueueSize = threadPoolAnalyzeQueueSize.asOptionOutput(isSecret = false),
      threadPoolAnalyzeSize = threadPoolAnalyzeSize.asOptionOutput(isSecret = false),
      threadPoolForceMergeSize = threadPoolForceMergeSize.asOptionOutput(isSecret = false),
      threadPoolGetQueueSize = threadPoolGetQueueSize.asOptionOutput(isSecret = false),
      threadPoolGetSize = threadPoolGetSize.asOptionOutput(isSecret = false),
      threadPoolSearchQueueSize = threadPoolSearchQueueSize.asOptionOutput(isSecret = false),
      threadPoolSearchSize = threadPoolSearchSize.asOptionOutput(isSecret = false),
      threadPoolSearchThrottledQueueSize = threadPoolSearchThrottledQueueSize.asOptionOutput(isSecret = false),
      threadPoolSearchThrottledSize = threadPoolSearchThrottledSize.asOptionOutput(isSecret = false),
      threadPoolWriteQueueSize = threadPoolWriteQueueSize.asOptionOutput(isSecret = false),
      threadPoolWriteSize = threadPoolWriteSize.asOptionOutput(isSecret = false)
    )
