package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetOpenSearchServiceIntegrationArgs private(
  integrationType: Output[String],
  sourceServiceName: Output[String]
) derives Encoder, ArgsEncoder

object GetOpenSearchServiceIntegrationArgs:
  def apply(
    integrationType: Input[String],
    sourceServiceName: Input[String]
  )(using Context): GetOpenSearchServiceIntegrationArgs =
    new GetOpenSearchServiceIntegrationArgs(
      integrationType = integrationType.asOutput(isSecret = false),
      sourceServiceName = sourceServiceName.asOutput(isSecret = false)
    )
