package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPgPgArgs private(
  dbname: Output[String],
  host: Output[String],
  maxConnections: Output[Int],
  password: Output[String],
  port: Output[Int],
  replicaUri: Output[String],
  sslmode: Output[String],
  uri: Output[String],
  user: Output[String]
) derives Encoder, ArgsEncoder

object GetPgPgArgs:
  def apply(
    dbname: Input[String],
    host: Input[String],
    maxConnections: Input[Int],
    password: Input[String],
    port: Input[Int],
    replicaUri: Input[String],
    sslmode: Input[String],
    uri: Input[String],
    user: Input[String]
  )(using Context): GetPgPgArgs =
    new GetPgPgArgs(
      dbname = dbname.asOutput(isSecret = false),
      host = host.asOutput(isSecret = false),
      maxConnections = maxConnections.asOutput(isSecret = false),
      password = password.asOutput(isSecret = true),
      port = port.asOutput(isSecret = false),
      replicaUri = replicaUri.asOutput(isSecret = true),
      sslmode = sslmode.asOutput(isSecret = false),
      uri = uri.asOutput(isSecret = true),
      user = user.asOutput(isSecret = false)
    )
