package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPgPgUserConfigMigrationArgs private(
  dbname: Output[Option[String]],
  host: Output[String],
  ignoreDbs: Output[Option[String]],
  method: Output[Option[String]],
  password: Output[Option[String]],
  port: Output[Int],
  ssl: Output[Option[Boolean]],
  username: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetPgPgUserConfigMigrationArgs:
  def apply(
    dbname: Input.Optional[String] = None,
    host: Input[String],
    ignoreDbs: Input.Optional[String] = None,
    method: Input.Optional[String] = None,
    password: Input.Optional[String] = None,
    port: Input[Int],
    ssl: Input.Optional[Boolean] = None,
    username: Input.Optional[String] = None
  )(using Context): GetPgPgUserConfigMigrationArgs =
    new GetPgPgUserConfigMigrationArgs(
      dbname = dbname.asOptionOutput(isSecret = false),
      host = host.asOutput(isSecret = false),
      ignoreDbs = ignoreDbs.asOptionOutput(isSecret = false),
      method = method.asOptionOutput(isSecret = false),
      password = password.asOptionOutput(isSecret = true),
      port = port.asOutput(isSecret = false),
      ssl = ssl.asOptionOutput(isSecret = false),
      username = username.asOptionOutput(isSecret = false)
    )
