package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPgPgUserConfigPgArgs private(
  autovacuumAnalyzeScaleFactor: Output[Option[Double]],
  autovacuumAnalyzeThreshold: Output[Option[Int]],
  autovacuumFreezeMaxAge: Output[Option[Int]],
  autovacuumMaxWorkers: Output[Option[Int]],
  autovacuumNaptime: Output[Option[Int]],
  autovacuumVacuumCostDelay: Output[Option[Int]],
  autovacuumVacuumCostLimit: Output[Option[Int]],
  autovacuumVacuumScaleFactor: Output[Option[Double]],
  autovacuumVacuumThreshold: Output[Option[Int]],
  bgwriterDelay: Output[Option[Int]],
  bgwriterFlushAfter: Output[Option[Int]],
  bgwriterLruMaxpages: Output[Option[Int]],
  bgwriterLruMultiplier: Output[Option[Double]],
  deadlockTimeout: Output[Option[Int]],
  defaultToastCompression: Output[Option[String]],
  idleInTransactionSessionTimeout: Output[Option[Int]],
  jit: Output[Option[Boolean]],
  logAutovacuumMinDuration: Output[Option[Int]],
  logErrorVerbosity: Output[Option[String]],
  logLinePrefix: Output[Option[String]],
  logMinDurationStatement: Output[Option[Int]],
  logTempFiles: Output[Option[Int]],
  maxFilesPerProcess: Output[Option[Int]],
  maxLocksPerTransaction: Output[Option[Int]],
  maxLogicalReplicationWorkers: Output[Option[Int]],
  maxParallelWorkers: Output[Option[Int]],
  maxParallelWorkersPerGather: Output[Option[Int]],
  maxPredLocksPerTransaction: Output[Option[Int]],
  maxPreparedTransactions: Output[Option[Int]],
  maxReplicationSlots: Output[Option[Int]],
  maxSlotWalKeepSize: Output[Option[Int]],
  maxStackDepth: Output[Option[Int]],
  maxStandbyArchiveDelay: Output[Option[Int]],
  maxStandbyStreamingDelay: Output[Option[Int]],
  maxWalSenders: Output[Option[Int]],
  maxWorkerProcesses: Output[Option[Int]],
  pgPartmanBgwDotInterval: Output[Option[Int]],
  pgPartmanBgwDotRole: Output[Option[String]],
  pgStatMonitorDotPgsmEnableQueryPlan: Output[Option[Boolean]],
  pgStatMonitorDotPgsmMaxBuckets: Output[Option[Int]],
  pgStatStatementsDotTrack: Output[Option[String]],
  tempFileLimit: Output[Option[Int]],
  timezone: Output[Option[String]],
  trackActivityQuerySize: Output[Option[Int]],
  trackCommitTimestamp: Output[Option[String]],
  trackFunctions: Output[Option[String]],
  trackIoTiming: Output[Option[String]],
  walSenderTimeout: Output[Option[Int]],
  walWriterDelay: Output[Option[Int]]
) derives Encoder, ArgsEncoder

object GetPgPgUserConfigPgArgs:
  def apply(
    autovacuumAnalyzeScaleFactor: Input.Optional[Double] = None,
    autovacuumAnalyzeThreshold: Input.Optional[Int] = None,
    autovacuumFreezeMaxAge: Input.Optional[Int] = None,
    autovacuumMaxWorkers: Input.Optional[Int] = None,
    autovacuumNaptime: Input.Optional[Int] = None,
    autovacuumVacuumCostDelay: Input.Optional[Int] = None,
    autovacuumVacuumCostLimit: Input.Optional[Int] = None,
    autovacuumVacuumScaleFactor: Input.Optional[Double] = None,
    autovacuumVacuumThreshold: Input.Optional[Int] = None,
    bgwriterDelay: Input.Optional[Int] = None,
    bgwriterFlushAfter: Input.Optional[Int] = None,
    bgwriterLruMaxpages: Input.Optional[Int] = None,
    bgwriterLruMultiplier: Input.Optional[Double] = None,
    deadlockTimeout: Input.Optional[Int] = None,
    defaultToastCompression: Input.Optional[String] = None,
    idleInTransactionSessionTimeout: Input.Optional[Int] = None,
    jit: Input.Optional[Boolean] = None,
    logAutovacuumMinDuration: Input.Optional[Int] = None,
    logErrorVerbosity: Input.Optional[String] = None,
    logLinePrefix: Input.Optional[String] = None,
    logMinDurationStatement: Input.Optional[Int] = None,
    logTempFiles: Input.Optional[Int] = None,
    maxFilesPerProcess: Input.Optional[Int] = None,
    maxLocksPerTransaction: Input.Optional[Int] = None,
    maxLogicalReplicationWorkers: Input.Optional[Int] = None,
    maxParallelWorkers: Input.Optional[Int] = None,
    maxParallelWorkersPerGather: Input.Optional[Int] = None,
    maxPredLocksPerTransaction: Input.Optional[Int] = None,
    maxPreparedTransactions: Input.Optional[Int] = None,
    maxReplicationSlots: Input.Optional[Int] = None,
    maxSlotWalKeepSize: Input.Optional[Int] = None,
    maxStackDepth: Input.Optional[Int] = None,
    maxStandbyArchiveDelay: Input.Optional[Int] = None,
    maxStandbyStreamingDelay: Input.Optional[Int] = None,
    maxWalSenders: Input.Optional[Int] = None,
    maxWorkerProcesses: Input.Optional[Int] = None,
    pgPartmanBgwDotInterval: Input.Optional[Int] = None,
    pgPartmanBgwDotRole: Input.Optional[String] = None,
    pgStatMonitorDotPgsmEnableQueryPlan: Input.Optional[Boolean] = None,
    pgStatMonitorDotPgsmMaxBuckets: Input.Optional[Int] = None,
    pgStatStatementsDotTrack: Input.Optional[String] = None,
    tempFileLimit: Input.Optional[Int] = None,
    timezone: Input.Optional[String] = None,
    trackActivityQuerySize: Input.Optional[Int] = None,
    trackCommitTimestamp: Input.Optional[String] = None,
    trackFunctions: Input.Optional[String] = None,
    trackIoTiming: Input.Optional[String] = None,
    walSenderTimeout: Input.Optional[Int] = None,
    walWriterDelay: Input.Optional[Int] = None
  )(using Context): GetPgPgUserConfigPgArgs =
    new GetPgPgUserConfigPgArgs(
      autovacuumAnalyzeScaleFactor = autovacuumAnalyzeScaleFactor.asOptionOutput(isSecret = false),
      autovacuumAnalyzeThreshold = autovacuumAnalyzeThreshold.asOptionOutput(isSecret = false),
      autovacuumFreezeMaxAge = autovacuumFreezeMaxAge.asOptionOutput(isSecret = false),
      autovacuumMaxWorkers = autovacuumMaxWorkers.asOptionOutput(isSecret = false),
      autovacuumNaptime = autovacuumNaptime.asOptionOutput(isSecret = false),
      autovacuumVacuumCostDelay = autovacuumVacuumCostDelay.asOptionOutput(isSecret = false),
      autovacuumVacuumCostLimit = autovacuumVacuumCostLimit.asOptionOutput(isSecret = false),
      autovacuumVacuumScaleFactor = autovacuumVacuumScaleFactor.asOptionOutput(isSecret = false),
      autovacuumVacuumThreshold = autovacuumVacuumThreshold.asOptionOutput(isSecret = false),
      bgwriterDelay = bgwriterDelay.asOptionOutput(isSecret = false),
      bgwriterFlushAfter = bgwriterFlushAfter.asOptionOutput(isSecret = false),
      bgwriterLruMaxpages = bgwriterLruMaxpages.asOptionOutput(isSecret = false),
      bgwriterLruMultiplier = bgwriterLruMultiplier.asOptionOutput(isSecret = false),
      deadlockTimeout = deadlockTimeout.asOptionOutput(isSecret = false),
      defaultToastCompression = defaultToastCompression.asOptionOutput(isSecret = false),
      idleInTransactionSessionTimeout = idleInTransactionSessionTimeout.asOptionOutput(isSecret = false),
      jit = jit.asOptionOutput(isSecret = false),
      logAutovacuumMinDuration = logAutovacuumMinDuration.asOptionOutput(isSecret = false),
      logErrorVerbosity = logErrorVerbosity.asOptionOutput(isSecret = false),
      logLinePrefix = logLinePrefix.asOptionOutput(isSecret = false),
      logMinDurationStatement = logMinDurationStatement.asOptionOutput(isSecret = false),
      logTempFiles = logTempFiles.asOptionOutput(isSecret = false),
      maxFilesPerProcess = maxFilesPerProcess.asOptionOutput(isSecret = false),
      maxLocksPerTransaction = maxLocksPerTransaction.asOptionOutput(isSecret = false),
      maxLogicalReplicationWorkers = maxLogicalReplicationWorkers.asOptionOutput(isSecret = false),
      maxParallelWorkers = maxParallelWorkers.asOptionOutput(isSecret = false),
      maxParallelWorkersPerGather = maxParallelWorkersPerGather.asOptionOutput(isSecret = false),
      maxPredLocksPerTransaction = maxPredLocksPerTransaction.asOptionOutput(isSecret = false),
      maxPreparedTransactions = maxPreparedTransactions.asOptionOutput(isSecret = false),
      maxReplicationSlots = maxReplicationSlots.asOptionOutput(isSecret = false),
      maxSlotWalKeepSize = maxSlotWalKeepSize.asOptionOutput(isSecret = false),
      maxStackDepth = maxStackDepth.asOptionOutput(isSecret = false),
      maxStandbyArchiveDelay = maxStandbyArchiveDelay.asOptionOutput(isSecret = false),
      maxStandbyStreamingDelay = maxStandbyStreamingDelay.asOptionOutput(isSecret = false),
      maxWalSenders = maxWalSenders.asOptionOutput(isSecret = false),
      maxWorkerProcesses = maxWorkerProcesses.asOptionOutput(isSecret = false),
      pgPartmanBgwDotInterval = pgPartmanBgwDotInterval.asOptionOutput(isSecret = false),
      pgPartmanBgwDotRole = pgPartmanBgwDotRole.asOptionOutput(isSecret = false),
      pgStatMonitorDotPgsmEnableQueryPlan = pgStatMonitorDotPgsmEnableQueryPlan.asOptionOutput(isSecret = false),
      pgStatMonitorDotPgsmMaxBuckets = pgStatMonitorDotPgsmMaxBuckets.asOptionOutput(isSecret = false),
      pgStatStatementsDotTrack = pgStatStatementsDotTrack.asOptionOutput(isSecret = false),
      tempFileLimit = tempFileLimit.asOptionOutput(isSecret = false),
      timezone = timezone.asOptionOutput(isSecret = false),
      trackActivityQuerySize = trackActivityQuerySize.asOptionOutput(isSecret = false),
      trackCommitTimestamp = trackCommitTimestamp.asOptionOutput(isSecret = false),
      trackFunctions = trackFunctions.asOptionOutput(isSecret = false),
      trackIoTiming = trackIoTiming.asOptionOutput(isSecret = false),
      walSenderTimeout = walSenderTimeout.asOptionOutput(isSecret = false),
      walWriterDelay = walWriterDelay.asOptionOutput(isSecret = false)
    )
