package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPgPgUserConfigPrivatelinkAccessArgs private(
  pg: Output[Option[Boolean]],
  pgbouncer: Output[Option[Boolean]],
  prometheus: Output[Option[Boolean]]
) derives Encoder, ArgsEncoder

object GetPgPgUserConfigPrivatelinkAccessArgs:
  def apply(
    pg: Input.Optional[Boolean] = None,
    pgbouncer: Input.Optional[Boolean] = None,
    prometheus: Input.Optional[Boolean] = None
  )(using Context): GetPgPgUserConfigPrivatelinkAccessArgs =
    new GetPgPgUserConfigPrivatelinkAccessArgs(
      pg = pg.asOptionOutput(isSecret = false),
      pgbouncer = pgbouncer.asOptionOutput(isSecret = false),
      prometheus = prometheus.asOptionOutput(isSecret = false)
    )
