package besom.api.aiven.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetPgTagArgs private(
  key: Output[String],
  value: Output[String]
) derives Encoder, ArgsEncoder

object GetPgTagArgs:
  def apply(
    key: Input[String],
    value: Input[String]
  )(using Context): GetPgTagArgs =
    new GetPgTagArgs(
      key = key.asOutput(isSecret = false),
      value = value.asOutput(isSecret = false)
    )
